/*
mcZoom.as

Incorrectly named really. This code deals with popUp windows

The popups transition in/out.

To make it work there is a container movieclip instance called Zoom on the
Zoom layer in the main movie.

If you don't need popups you can remove the Zoom layer and the mcZoom from the
library then recompile.

*/


var Entrance="DONE";
var Exit="DONE";
var FadeStep=10;	// affects how quickly zoom/popup clips fade in/out
var ScaleStep=5;	// affects how quickly zoom/popup clips grow
var ScaleSteps=20;	// number of cycle to go from min to max scale
var WipeStep=1;
var maxXscale=0;	// set when clip is instantiated
var maxYscale=0;
var Param:Object;
var dragging=false;
var AccelRate;		// set by call to ShowClip
var xAccel=1;		// starts at 1 and is incremented to move faster
var yAccel=1;
var lastxDir=0;		// to enable us to detect change of scroll direction
var lastyDir=0;



var noscroll_l;		// used to create noscroll zones
var noscroll_r;		// when mouse scrolling is used
var noscroll_t;
var noscroll_b;
var scrollboundary_l;	// limits of scrolling
var scrollboundary_r;	// calculated based on clip width/height
var scrollboundary_t;	// passed in as ShowClip parameters
var scrollboundary_b;

/*
BNN V1.04 changed ShowClip to accept an object instead of a parameter list
this will make it easier to extend in future.

We assume if src,sx,sy,scale are defined then the old style is being used
otherwise only one parameter (object) is expected

*/


function ShowClip(src,sx,sy,scale)
{

	if (PopUp) UnloadClip();	// only one at a time (at the moment)

	// reset container dimensions etc
	_root.Zoom._x=_root.WAX;
	_root.Zoom._y=_root.WAY;
	_root.Zoom._xscale=_root.Zoom._yscale=100;

	/*
	if sx is defined then assume 4 parameters
	otherwise assume an object has been passed
	*/
	if (sx==undefined)
		{
		//trace("new style call");
		Param=src;	// src is expect to be an object
		}
	else
		{
		//trace("Old style call");
		Param=new Object();
		Param.src=src;
		Param.x=sx;
		Param.y=sy;
		Param.scale=scale;
		}
	// default values for missing params
	
	if (Param.entrance==undefined) Param.entrance="APPEAR";
	if (Param.exit==undefined) Param.exit="DISAPPEAR";
	if (Param.canDrag==undefined) Param.canDrag=false;
	if (Param.canScroll==undefined) Param.canScroll=false;

	// now create the actual clip

	this.createEmptyMovieClip("PopUp",this.getNextHighestDepth());

	/*
	pass parameters to popup.swf via _root.PopUpParams

	Sadly this means only one popup at a time - future work needed
	maybe use an array of objects?
	*/

	_root.PopUpParams=new Object();
	_root.PopUpParams.src=Param.src;
	_root.PopUpParams.callback=PopUpOnLoadInit;
	_root.PopUpParams.x=(_root.WAW-PopUp._width)/2;	// center on screen
	_root.PopUpParams.y=(_root.WAW-PopUp._width)/2;

	/*
	the Popup is actually an external SWF popup.swf
	*/
	
	loadMovie("popup.swf","PopUp"); 

	
	// initialise mouse scrolling accelerations

	xAccel=yAccel=1;		
	AccelRate=_root.scrollAccel;

	// no scroll zones

	var czw=_root.clickZoneWidth;

	noscroll_l=(_root.WAW/2)- czw;
	noscroll_r=noscroll_l+2*czw;
	noscroll_t=(_root.WAH/2)-czw;
	noscroll_b=noscroll_t+2*czw;

	// scroll boundaries

	var sb=_root.scrollBoundary;

	if (Param.width && Param.height)
		{ 
		scrollboundary_l=_root.WAX-Param.width+sb;
		scrollboundary_r=_root.WAX+_root.WAW-sb;
		scrollboundary_t=_root.WAY-Param.height+sb;
		scrollboundary_b=_root.WAY+_root.WAH-sb;
		}
	else
		{
		// this is just to make sure some boundary exists
		scrollboundary_l=_root.WAX+sb;
		scrollboundary_r=_root.WAX+_root.WAW-sb;
		scrollboundary_t=_root.WAY+sb;
		scrollboundary_b=_root.WAY+_root.WAH-sb;
		}
	/* 
	there is nothing more we can do till the clip is loaded
	The callback will take care of that
	*/
}

/*

PopUpOnLoadInit()

A callback method - called when the MovieClipLoader
calls the onLoadInit event method.

At this time the clip is on the timeline and can be
manipulated

*/

function PopUpOnLoadInit()
	{

	//position the clip

	PopUp._x=Param.x;
	PopUp._y=Param.y;

	/* 
	at this point the clip has the same dimensions of the source.

	the clip original scaling may not be 100% so we adjust the original
	scaling accordingly.

	This is just due to the way flash handles MovieClips.
	*/

	PopUp._xscale=PopUp._yscale=PopUp._xscale*Param.scale/100;

	// remember the scaling so we can GROW/EXPAND properly

	maxXscale=PopUp._xscale;
	maxYscale=PopUp._yscale;
	ScaleStep=maxXscale/ScaleSteps;		// rate of scaling

	switch(Param.entrance)
	{
	case "GROW": 	PopUp._xscale*=0.1;	// Oddly 0 for x&y scale causes 90 degree CW rotation
						// since it will zoom in quickly starting at 10% is ok
		  	PopUp._yscale*=0.1;
		  	break;

	case "FADE":	PopUp._alpha=0;
			break;
					
	case "EXPANDHORIZ":
			PopUp._xscale*=0.1;
			break;
	case "EXPANDVERT":
			PopUp._yscale*=0.1;
			break;
	}

	// OEF is used to scroll the popup only
	if (Param.canScroll) onEnterFrame=popup_OEF;


	/*
	start the entrance transition and 
	tell caller (if callback required)
	*/
	Entrance=Param.entrance;
	if (Param.callback) Param.callback("ENTER");
}


/*

popup_OEF()

In here we scroll the popup when the mouse moves but only if
canScroll==true

this function is assigned to onEnterFrame when the PopUp is created
and released when it is removed.

*/


popup_OEF=function()
{
var mx=_root._xmouse;
var my=_root._ymouse;

// test for x-noscroll band
if ((mx>noscroll_r) || (mx<noscroll_l)) 
	{
	var xDir=(mx>(_root.WAW/2))?-1:+1;
	if (xDir!=lastxDir) { lastxDir=xDir; xAccel=1; }

	if ((PopUp._x>scrollboundary_l) && (PopUp._x<scrollboundary_r)) { PopUp._x+=xDir*xAccel; xAccel+=AccelRate;}
	else xAccel=1;

	if (PopUp._x<scrollboundary_l) PopUp._x=scrollboundary_l+1;
	if (PopUp._x>scrollboundary_r) PopUp._x=scrollboundary_r-1;
	}

// test for y-noscroll band
if ((my>noscroll_b) || (my<noscroll_t))
	{
	var yDir=(my>(_root.WAH/2))?-1:+1;
	if (yDir!=lastyDir) { lastyDir=yDir; yAccel=1; }

	if ((PopUp._y>scrollboundary_t) && (PopUp._y<scrollboundary_b)) { PopUp._y+=yDir*yAccel; yAccel+=AccelRate;}
	else yAccel=1;

	if (PopUp._y<scrollboundary_t) PopUp._y=scrollboundary_t+1;
	if (PopUp._y>scrollboundary_b) PopUp._y=scrollboundary_b-1;
	}

}

/*

onPress()

*/

onPress=function()
{
if (Param.canDrag)
	{
	startDrag(this);
	dragging=true;
	}
}

/*

onRollOut()

if drag mode is enabled rollout is used to close the PopUp

*/

onRollOut=function()
{
if (Param.canDrag)
	{
	dragging=false;
	Exit=Param.exit;
	if (Param.callback) Param.callback("EXIT");
	}
}

/*

onRelease()

if dragging we just stop otherwise we use the mouseclick
to close the PopUp
*/

onRelease=function()
{
if (Param.canDrag && dragging)
	{
	stopDrag();
	dragging=false;
	return;
	}
	
Exit=Param.exit;
if (Param.callback) Param.callback("EXIT");

}


/*

unloadClip()

removes the PopUp()

*/

function UnloadClip()
{
	Exit="DONE";
	unloadMovie(PopUp);
	removeMovieClip(PopUp);
	delete onEnterFrame;
}


/*

Transitions()

used to control how PopUp appears/disappears

called by a timer on actions_f11.as

*/

function Transitions()
{
switch(Entrance)
	{
	case "FADE":	PopUp._alpha+=FadeStep;
		 	if (PopUp._alpha>=100) Entrance="DONE";
			break;

	case "APPEAR": 	break; // no transition needed

	case "DONE": 	break;

	case "GROW": 	PopUp._xscale+=ScaleStep;
			PopUp._yscale+=ScaleStep;
			if (PopUp._xscale>=maxXscale)
			 	{
				// make sure it ends up the size the caller wants
				PopUp._xscale=maxXscale;
				PopUp._yscale=maxYscale;
				Entrance="DONE";
				}
			break;

	case "EXPANDHORIZ":	
			PopUp._xscale+=WipeStep;
			if (PopUp._xscale>=maxXscale)
			 	{
				// make sure it ends up the size the caller wants
				PopUp._xscale=maxXscale;
				Entrance="DONE";
				}
			break;
	case "EXPANDVERT":	
			PopUp._yscale+=WipeStep;
		 	if (PopUp._yscale>=maxYscale)
			 	{
				// make sure it ends up the size the caller wants
				PopUp._yscale=maxYscale;
				Entrance="DONE";
				}
			break;
				 
	default:	Trace("Unknown PopUp entrance transition "+Entrance);
	}
	
	switch(Exit)
	{
	case "FADE": 	PopUp._alpha-=FadeStep;
			if (PopUp._alpha<=0) UnloadClip();
			break;

	case "DONE": 	break;

	case "DISAPPEAR":	
			UnloadClip(); break;

	case "SHRINK": 	PopUp._xscale-=ScaleStep;
			PopUp._yscale-=ScaleStep;
			if (PopUp._xscale<=0) UnloadClip();
			break;

	case "SHRINKHORIZ": 	
			PopUp._xscale-=WipeStep;
			if (PopUp._xscale<=0) UnloadClip();
			break;

	case "SHRINKVERT": 	
			PopUp._yscale-=WipeStep;
			if (PopUp._xscale<=0) UnloadClip();
			break;
						
	default:	Trace("Unknown exit transition "+Exit);
			UnloadClip();
			break;
	}
}

/*
debugging stuff
*/
function Reveal(X,mc)
{
var mc_width=mc._width;
var mc_height=mc._height;
var mc_xscale=mc._xscale;
var mc_yscale=mc._yscale;
var mc_x=mc._x;
var mc_y=mc._y;

trace(X+" mcZoom mc="+mc+" w="+mc_width+" h="+mc_height+" xscale="+mc_xscale+" yscale="+mc_yscale+" x="+mc_x+" y="+mc_y);
}

